
import { RentalDailyView }   from './view/RentalDailyView.js';
import { RentalWeeklyView }  from './view/RentalWeeklyView.js';
import { RentalMonthlyView } from './view/RentalMonthlyView.js';




export class RentalOccupationWidget {
	
	tpl = `
		<div class="page-header">
			<div class="toolbox">
				<a href="javascript:void(0);" [onclick]="widget.addContract_Click" class="fa fa-plus"></a>
			</div>
			<h1>Bezetting</h1>
		</div>
		
		<div class="rental-occupation-search">
			<div style="display: flex;" class="container-settings">
				<ez-date name="d" 
							label="{{_('Date')}}" 
							[value]="selectedDate"></ez-date>
				
				<ez-radio name="v" 
							label="Weergave" 
							value="m"
							[onchange]="widget.view_Changed" 
							style="margin-left: 10px;">
					<option value="d">Dag</option>
					<option value="w">Week</option>
					<option value="m">Maand</option>
				</ez-radio>
			</div>
		
			<input type="text" name="q" value="" placeholder="{{_('Search...')}}" />
		</div>
		
		
		<hr/>
		
		<div id="view-container" class="rental-occupation-container"></div>
		
	`;
	
	
	container = null;
	
	view = null;
	selectedDate = format_date(new Date());
	
	
	
	init(e) {
		this.container = e;
		
		this.render();
	}
	
	
	
	addContract_Click() {
		gotoRoute('/sales/rental/new/');
	}
	
	
	view_Changed() {
		this.showView();
		
		this.search();
	}
	
	showView() {
		let v = $('.container-settings input[name=v]:checked').val();
		
		
		if (v == 'd') {
			this.view = new RentalDailyView( );
		}
		else if (v == 'w') {
			this.view = new RentalWeeklyView( );
		}
		else if (v == 'm') {
			this.view = new RentalMonthlyView( );
		}
		
		this.view.init( '#view-container' );
		
		this.view.render();
	}
	
	
	async search() {
		
		let r = await postJson( '/service/sales/rental/articleSearch.do', {
			pageSize: 500,
			q: $('.rental-occupation-search input[name=q]').val(),
			occupation: 1,
			startOccupation: this.view.getStart(),
			endOccupation: this.view.getEnd()
		});
		
		let json = await r.json();
		
		this.view.renderSearch( json );
	}
	
	
	
	render() {
		
		let ezTpl = new EzTemplate( this.container );
		ezTpl.setObject('widget', this);
		ezTpl.setVar('selectedDate', this.selectedDate);
		
		ezTpl.loadHtml( this.tpl );
		
		ezTpl.render();
		
		this.showView();
		
		this.search();
		
		
		let inp_date = $('.rental-occupation-search input[name=d]');
		console.log('len', inp_date.length);
		inp_date.on('change dp.change', () => {
			this.search();
		});
		
		
		//
		let inp_q = $('.rental-occupation-search input[name=q]');
		inp_q.on('change', () => {
			this.search();
		});
		inp_q.focus();
		
	}
	
	
}


